/*
		Bayfront Technologies
		Protocol/State Machine
			 Header File
			 Version 1.2
*/

/* -- sm_exec() return values -- */
#define smOK 0		/* return ok */
#define smActIndError 1	/* action table index error */
#define smSwRtnError 2	/* switch return value error */
#define smStateError 3	/* state out of bounds */
#define smEventError 4	/* event out of bounds */
#define smATypeError 5	/* unknown action type encountered */

/* ---- Interpreter constants ---- */

/* action types in the action tuple entry */
#define JmpOp 0
#define ActionOp 1
#define NullActOp 2
#define SwitchOp 3
#define ActionParamOp 5
#define SwitchParamOp 6

/* action array TNsi values (max # of states = 520) */
#define ContExec 521      /* continue exec of action array */
#define NoStateChg 520    /* no state change */

/* action array entry */
typedef struct AAEntry {
	int	(*pTAct)();
	int	TType;
	int	TNsi;
} AAEntry;

/* switch statement table */
typedef struct SWTBL {
		int      SwInd; /* index into the SwLblVect structure */
		int      SwMax;	/* max return values */
} SWTBL;

/* data structures describing the state machine */
typedef struct SM {
	int          smStates;		/* max states in sm */
	int          smEvents;		/* max events in sm */
	int          smAASize;		/* action array size */
	int          *pSwLblVect;	/* vectors into the action array */
	struct SWTBL *pSwTbl;		/* contains info on switch statements */
	int          **pStateEvent; /* state/event -> action array vector */
	struct AAEntry *pActArray;  /* action array */
} SM;
