/* ---- dataxfer state machine table file ---- */

#include "cape.h"
#include "b:\examples\dataxfer.h"

/* Switch Return Value Table (indices into the Action Vector Table) */
static int dataxfer_SwLblVect[] = {
    14,    17,          /* 'CheckMsg' */
    35,    37,          /* 'Retry' */
}; 

/* Indicies into the dataxfer_SwLblVect array, # of return values */
static SWTBL dataxfer_SwTbl[] = {
    {0, 2},
    {2, 2},
};

/* ---- Action routines which pass arguments ---- */

int RestartTimerTack(pECB)
void *pECB;
{ return(RestartTimer(Tack,pECB)); }

int RestartTimerTrecv(pECB)
void *pECB;
{ return(RestartTimer(Trecv,pECB)); }

int StartTimerTack(pECB)
void *pECB;
{ return(StartTimer(Tack,pECB)); }

int StartTimerTsend(pECB)
void *pECB;
{ return(StartTimer(Tsend,pECB)); }

int StartTimerTrecv(pECB)
void *pECB;
{ return(StartTimer(Trecv,pECB)); }

int StartTimerTconn(pECB)
void *pECB;
{ return(StartTimer(Tconn,pECB)); }

int StopTimerTack(pECB)
void *pECB;
{ return(StopTimer(Tack,pECB)); }

int StopTimerTsend(pECB)
void *pECB;
{ return(StopTimer(Tsend,pECB)); }

int StopTimerTrecv(pECB)
void *pECB;
{ return(StopTimer(Trecv,pECB)); }

int StopTimerTconn(pECB)
void *pECB;
{ return(StopTimer(Tconn,pECB)); }


/* ---- dataxfer Action Vector Jump Table [MaxStates][MaxEvents] ---- */
static int dataxfer_Idle[] = {
     0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 3, 0, 
     0, 0, 0
};
static int dataxfer_Receiving[] = {
     0, 0, 10, 0, 0, 0, 0, 38, 11, 13, 0, 0, 0, 0, 40, 
     0, 0, 0
};
static int dataxfer_Sending[] = {
     0, 0, 0, 23, 0, 0, 0, 38, 0, 0, 0, 0, 0, 0, 40, 
     24, 26, 0
};
static int dataxfer_SetupReceive[] = {
     0, 5, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0, 7, 0, 40, 
     0, 0, 5
};
static int dataxfer_SetupSend[] = {
     0, 18, 0, 0, 20, 0, 0, 38, 0, 0, 0, 18, 0, 0, 40, 
     0, 0, 0
};
static int dataxfer_WaitAck[] = {
     31, 0, 0, 0, 0, 32, 0, 38, 0, 0, 34, 0, 0, 0, 40, 
     0, 0, 0
};
static int *dataxfer_StateEvent[] = {
        dataxfer_Idle,
        dataxfer_Receiving,
        dataxfer_Sending,
        dataxfer_SetupReceive,
        dataxfer_SetupSend,
        dataxfer_WaitAck
};

/* ---- Action Vector Table ---- */
static AAEntry    dataxfer_ActArray[] = {
     /* Null Entry */     {0, 0, 0},    /* fcn, type, jmp or newstate */
     /* Action   1 */     {sUsr_Connect, 1, 521},
     /* Action   2 */     {StartTimerTconn, 5, 3},
     /* Action   3 */     {sNet_Connect, 1, 521},
     /* Action   4 */     {StartTimerTconn, 5, 4},
     /* Action   5 */     {sNet_Refuse, 1, 521},
     /* Action   6 */     {StopTimerTconn, 5, 0},
     /* Action   7 */     {sNet_Accept, 1, 521},
     /* Action   8 */     {StopTimerTconn, 5, 521},
     /* Action   9 */     {StartTimerTrecv, 5, 1},
     /* Goto    10 */     {0, 0, 42},
     /* Action  11 */     {sUsr_Disconnect, 1, 521},
     /* Action  12 */     {StopTimerTrecv, 5, 0},
     /* Switch  13 */     {CheckMsg, 3, 0},
     /* Action  14 */     {sUsr_Message, 1, 521},
     /* Action  15 */     {sNet_Ack, 1, 521},
     /* Action  16 */     {RestartTimerTrecv, 5, 520},
     /* Action  17 */     {sNet_NotAck, 1, 520},
     /* Action  18 */     {sUsr_Refuse, 1, 521},
     /* Action  19 */     {StopTimerTconn, 5, 0},
     /* Action  20 */     {sUsr_Accept, 1, 521},
     /* Action  21 */     {StopTimerTconn, 5, 521},
     /* Action  22 */     {StartTimerTsend, 5, 2},
     /* Goto    23 */     {0, 0, 42},
     /* Action  24 */     {sNet_Disconnect, 1, 521},
     /* Action  25 */     {StopTimerTsend, 5, 0},
     /* Action  26 */     {sNet_Message, 1, 521},
     /* Action  27 */     {sUsr_Ack, 1, 521},
     /* Action  28 */     {StopTimerTsend, 5, 521},
     /* Action  29 */     {RetryReset, 1, 521},
     /* Action  30 */     {StartTimerTack, 5, 5},
     /* Goto    31 */     {0, 0, 42},
     /* Action  32 */     {StopTimerTack, 5, 521},
     /* Action  33 */     {StartTimerTsend, 5, 2},
     /* Switch  34 */     {Retry, 3, 1},
     /* Action  35 */     {ResendMessage, 1, 521},
     /* Action  36 */     {RestartTimerTack, 5, 520},
     /* Goto    37 */     {0, 0, 42},
     /* Action  38 */     {sUsr_Disc, 1, 521},
     /* Action  39 */     {StopAllTimers, 1, 0},
     /* Action  40 */     {sNet_Disc, 1, 521},
     /* Action  41 */     {StopAllTimers, 1, 0},
     /* Action  42 */     {sUsr_Abort, 1, 521},
     /* Action  43 */     {sNet_Abort, 1, 521},
     /* Action  44 */     {StopAllTimers, 1, 0},
};

/* ---- dataxfer state machine definitions ---- */
SM dataxfer = {
    dataxfer_MaxStates,    /* max states */
    dataxfer_MaxEvents,    /* max events */
    dataxfer_ActArraySize, /* # of entries in the action array */
    dataxfer_SwLblVect,    /* Switch return value ActArray indicies */
    dataxfer_SwTbl,        /* SwLblVect index & # of rtn values */
    dataxfer_StateEvent,   /* state/event to action vector tbl */
    dataxfer_ActArray      /* action vector table */
};

