/* -------- dataxfer state machine header file  -------- */

/* ---- States ---- */ 
#define Idle 0
#define Receiving 1
#define Sending 2
#define SetupReceive 3
#define SetupSend 4
#define WaitAck 5

#define dataxfer_MaxStates 6
#define dataxfer_InitialState Idle

/* ---- Events ---- */
#define Tack_timeout 0
#define Tconn_timeout 1
#define Trecv_timeout 2
#define Tsend_timeout 3
#define rNet_Accept 4
#define rNet_Ack 5
#define rNet_Connect 6
#define rNet_Disc 7
#define rNet_Disconnect 8
#define rNet_Message 9
#define rNet_NotAck 10
#define rNet_Refuse 11
#define rUsr_Accept 12
#define rUsr_Connect 13
#define rUsr_Disc 14
#define rUsr_Disconnect 15
#define rUsr_Message 16
#define rUsr_Refuse 17

#define dataxfer_MaxEvents 18

/* ---- Timer Defines ---- */
#define Tack 0
#define Tconn 1
#define Trecv 2
#define Tsend 3

/* ---- Switch Labels ---- */

/* 'CheckMsg' return values */
#define MsgOK 0
#define MsgBad 1

/* 'Retry' return values */
#define YesRetry 0
#define NoRetry 1

/* number of unique switch labels = 4 */

#define dataxfer_ActArraySize 45


/* ---- Action Subroutine Declarations ---- */
    extern int CheckMsg();
    extern int ResendMessage();
    extern int RestartTimer();
    extern int Retry();
    extern int RetryReset();
    extern int StartTimer();
    extern int StopAllTimers();
    extern int StopTimer();
    extern int sNet_Abort();
    extern int sNet_Accept();
    extern int sNet_Ack();
    extern int sNet_Connect();
    extern int sNet_Disc();
    extern int sNet_Disconnect();
    extern int sNet_Message();
    extern int sNet_NotAck();
    extern int sNet_Refuse();
    extern int sUsr_Abort();
    extern int sUsr_Accept();
    extern int sUsr_Ack();
    extern int sUsr_Connect();
    extern int sUsr_Disc();
    extern int sUsr_Disconnect();
    extern int sUsr_Message();
    extern int sUsr_Refuse();
/* number of actions = 25 */
