/* ---- ex1 state machine table file ---- */

#include "cape.h"
#include "b:\examples\ex1.h"

/* Switch Return Value Table (indices into the Action Vector Table) */
static int ex1_SwLblVect[1];
static SWTBL ex1_SwTbl[1];


/* ---- Action routines which pass arguments ---- */


/* ---- ex1 Action Vector Jump Table [MaxStates][MaxEvents] ---- */
static int ex1_State1[] = {
     1, 3
};
static int ex1_State2[] = {
     4, 5
};
static int *ex1_StateEvent[] = {
        ex1_State1,
        ex1_State2
};

/* ---- Action Vector Table ---- */
static AAEntry    ex1_ActArray[] = {
     /* Null Entry */     {0, 0, 0},    /* fcn, type, jmp or newstate */
     /* Action   1 */     {Action1, 1, 521},
     /* Action   2 */     {Action2, 1, 1},
     /* Action   3 */     {Action3, 1, 520},
     /* Action   4 */     {Action4, 1, 520},
     /* Action   5 */     {Action5, 1, 521},
     /* Action   6 */     {Action6, 1, 0},
};

/* ---- ex1 state machine definitions ---- */
SM ex1 = {
    ex1_MaxStates,    /* max states */
    ex1_MaxEvents,    /* max events */
    ex1_ActArraySize, /* # of entries in the action array */
    ex1_SwLblVect,    /* Switch return value ActArray indicies */
    ex1_SwTbl,        /* SwLblVect index & # of rtn values */
    ex1_StateEvent,   /* state/event to action vector tbl */
    ex1_ActArray      /* action vector table */
};

