/* -------- q931 state machine header file  -------- */

/* ---- States ---- */ 
#define U00_Null 0
#define U01_CallInitiated 1
#define U02_OverlapSending 2
#define U03_OutgoingCallProc 3
#define U04_CallDelivered 4
#define U06_CallPresent 5
#define U07_CallReceived 6
#define U08_ConReq 7
#define U09_IncomingCallProc 8
#define U10_Active 9
#define U11_DiscReq 10
#define U12_DiscInd 11
#define U15_SuspendReq 12
#define U17_ResumeReq 13
#define U19_ReleaseReq 14
#define U25_OverlapReceiving 15

#define q931_MaxStates 16
#define q931_InitialState U00_Null

/* ---- Events ---- */
#define T302_timeout 0
#define T303_timeout 1
#define T304_timeout 2
#define T305_timeout 3
#define T308_timeout 4
#define T309_timeout 5
#define T310_timeout 6
#define T313_timeout 7
#define T318_timeout 8
#define T319_timeout 9
#define rnet_Alerting 10
#define rnet_CallProc 11
#define rnet_ConAck 12
#define rnet_Connect 13
#define rnet_DL_Est_Conf 14
#define rnet_DL_Est_Ind 15
#define rnet_DL_Rel_Ind 16
#define rnet_Disc 17
#define rnet_Info 18
#define rnet_Notify 19
#define rnet_Progress 20
#define rnet_Release 21
#define rnet_ReleaseComp 22
#define rnet_ResumeAck 23
#define rnet_ResumeRej 24
#define rnet_SetUp 25
#define rnet_SetUpAck 26
#define rnet_Status 27
#define rnet_StatusEnquiry 28
#define rnet_SuspendAck 29
#define rnet_SuspendRej 30
#define rnet_UnrecognizedMsg 31
#define ruser_AlertingReq 32
#define ruser_DiscReq 33
#define ruser_InfoReq 34
#define ruser_MoreInfoReq 35
#define ruser_NotifyReq 36
#define ruser_ProcReq 37
#define ruser_ProgressReq 38
#define ruser_RejReq 39
#define ruser_ReleaseReq 40
#define ruser_RestartReq 41
#define ruser_Resume 42
#define ruser_SetUp 43
#define ruser_SetUpRsp 44
#define ruser_SuspendReqcallid 45

#define q931_MaxEvents 46

/* ---- Timer Defines ---- */
#define T302 0
#define T303 1
#define T304 2
#define T305 3
#define T308 4
#define T309 5
#define T310 6
#define T313 7
#define T318 8
#define T319 9

/* ---- Switch Labels ---- */

/* 'AckOption' return values */
#define YesAck 0
#define NoAck 1

/* 'AnyTimersRunning' return values */
#define NoTimersRunning 0
#define YesTimersRunning 1

/* 'CSZeroNonZero' return values */
#define CSZero 0
#define CSNonZero 1

/* 'CauseOption' return values */
#define C1 0
#define C2 1

/* 'CheckSetUpMsg' return values */
#define SetUpOk 0
#define SetUpManElementMissing 1
#define SetUpManElementError 2

/* 'CheckStatusCsField' return values */
#define CsZero 0
#define CsNotZero 1

/* 'CompatibleStateCheck' return values */
#define YesCompatible 0
#define NoCompatible 1

/* 'DLOption' return values */
#define DLStatusOpt 0
#define DLStatusEnqOpt 1
#define DLDefaultOpt 2

/* 'DLRelOption' return values */
#define NullOption 0
#define NoNullOption 1

/* 'FirstTimeOut' return values */
#define YesFirst 0
#define NoFirst 1

/* 'ProgressType' return values */
#define InterNetworking 0
#define Tone 1

/* 'RejectOption' return values */
#define YesReject 0
#define NoReject 1

/* 'RelOption' return values */
#define RelOpt 0
#define RelCompOpt 1

/* 'StatusEnqOption' return values */
#define YesEnqOption 0
#define NoEnqOption 1

/* 'TimerRunning' return values */
#define YesRunning 0
#define NoRunning 1

/* number of unique switch labels = 32 */

#define q931_ActArraySize 274


/* ---- Action Subroutine Declarations ---- */
    extern int AckOption();
    extern int AnyTimersRunning();
    extern int BChanMaintenance();
    extern int CSZeroNonZero();
    extern int CallRefSelection();
    extern int CauseOption();
    extern int CheckSetUpMsg();
    extern int CheckStatusCsField();
    extern int CompatibleStateCheck();
    extern int DLOption();
    extern int DLRelOption();
    extern int FS();
    extern int FirstTimeOut();
    extern int ProgressType();
    extern int RejectOption();
    extern int RelCallRef();
    extern int RelOption();
    extern int RestartTimer();
    extern int SavePkt();
    extern int StartTimer();
    extern int StatusEnqOption();
    extern int StopAllTimers();
    extern int StopTimer();
    extern int TimerRunning();
    extern int snet_Alerting();
    extern int snet_CallProc();
    extern int snet_Connect();
    extern int snet_ConnectAck();
    extern int snet_DL_Est_Rel();
    extern int snet_Disc();
    extern int snet_Info();
    extern int snet_Notify();
    extern int snet_Progress();
    extern int snet_Release();
    extern int snet_ReleaseComp();
    extern int snet_Resume();
    extern int snet_SetUp();
    extern int snet_SetUpAck();
    extern int snet_Status();
    extern int snet_StatusEnquiry();
    extern int snet_Suspendcallid();
    extern int suser_AlertingInd();
    extern int suser_DataLinkFailureInd();
    extern int suser_DiscInd();
    extern int suser_ErrorInd();
    extern int suser_InfoInd();
    extern int suser_MoreInfoInd();
    extern int suser_NotifyInd();
    extern int suser_ProcInd();
    extern int suser_ProgressInd();
    extern int suser_RejectInd();
    extern int suser_RelInderror();
    extern int suser_ReleaseConf();
    extern int suser_ReleaseInd();
    extern int suser_RestartConf();
    extern int suser_ResumeConf();
    extern int suser_SetUpCompInd();
    extern int suser_SetUpConf();
    extern int suser_SetUpInd();
    extern int suser_StatusInd();
    extern int suser_SuspendConf();
    extern int suser_TimeoutInd();
/* number of actions = 62 */
