/* Copyright (C) 1992 Bayfront Technologies, All Rights Reserved */

/* test file to test the q931 state machine */
/* compile and link with sm_exec.c, q931.c and q931act.c */

#include "cape.h"	/* SM structure defined here */
#include "q931.h"	/* q931_MaxStates/q931_MaxEvents defined here */
#include "q931.str"	/* State/Event names file */

extern sm_exec();	/* state machine executor (sm_exec.c) */
extern SM q931;		/* from q931.c */


/* -- trace actions of a state machine from InitialState on Event -- */
int
sm_trace(InitState, Event)
int InitState, Event;
{
	int rtnval;
	int State;
	unsigned char *pECB = 0;

	if ((State = InitState) > (q931_MaxStates-1)) {
		printf("State out of range (max = %d)\n",q931_MaxStates-1);
		return 1;
	}
	if (Event > (q931_MaxEvents-1)) {
		printf("Event out of range (max = %d)\n",q931_MaxEvents-1);
		return 1;
	}

	/* -- display start state/event names -- */
	printf("start: State= %s     Event= %s\n",
		q931_StateNames[State], q931_EventNames[Event]);

	/* -- call state machine executor -- */
	rtnval = sm_exec(&q931, &State, Event, pECB);

	/* -- printout new state and sm_exec return value if not ok -- */
	if (State != InitState)
		printf("     New State = %s\n",q931_StateNames[State]);
	if (rtnval != smOK)
		printf("WARNING: sm_exec return value=%d\n",rtnval);
	else
		printf(" execute ok\n");
}

void
main(argc, argv)
int argc;
char **argv;
{
	int rtnval;
	int State, Event, InitState;
	unsigned char *pECB = 0;

        /* --  one trace from the command line -- */
	if (argc == 3) {
                InitState = atoi(argv[1]); Event = atoi(argv[2]);
                exit(sm_trace(InitState, Event));
        }

        /* --  repeat traces on read state/event -- */
        printf("Enter: <state #> <event #> (see q931.h for codes, type quit to exit)\n");
        while ( scanf("%d %d", &InitState, &Event)> 0)
              sm_trace(InitState, Event);

}

