
/*
 *         Bayfront Technologies
 *    State Machine/Protocol Executor
 *              Version 1.2
 */
#include "cape.h"

#define DEMAND(x, y) if (!(x)) return(y);

int
sm_exec(psm, curstate, event, pdata)
SM *psm;
int *curstate, event;
unsigned char *pdata;
{
    int i, ActInd, RtnVal;
    unsigned short OpType;

    /* get action index from state & event */
    DEMAND(*curstate < psm->smStates, smStateError);
    DEMAND(event < psm->smEvents, smEventError);

    ActInd = (*(*(psm->pStateEvent+*curstate)+event));

    do { /* loop until a new/no state termination */
	switch (psm->pActArray[ActInd].TType) {
	    case ActionOp:
	    case ActionParamOp:
		DEMAND(ActInd < psm->smAASize, smActIndError);

		/* execute action */
		RtnVal = (*psm->pActArray[ActInd].pTAct)(pdata);

		/* go to next tuple if new state not assigned */
		if (psm->pActArray[ActInd].TNsi == ContExec)
			ActInd++;
		else
			if (psm->pActArray[ActInd].TNsi == NoStateChg)
			return(smOK);
			else {
			*curstate = psm->pActArray[ActInd].TNsi;
			return(smOK);
		    }
		break;

	case SwitchOp:
	case SwitchParamOp:
		DEMAND(ActInd < psm->smAASize, smActIndError);
		RtnVal = (*psm->pActArray[ActInd].pTAct)(pdata);

	    /* check RtnVal for range correctness */
	    DEMAND((RtnVal >= 0 &&
		RtnVal <= psm->pSwTbl[psm->pActArray[ActInd].TNsi].SwMax-1),
		smSwRtnError);

	    ActInd = psm->pSwLblVect[psm->pSwTbl[
			 psm->pActArray[ActInd].TNsi].SwInd + RtnVal];
	    break;

	case JmpOp:
		ActInd = psm->pActArray[ActInd].TNsi;
	    if (ActInd == 0) return(smOK);
	    break;

	case NullActOp:
		if (psm->pActArray[ActInd].TNsi == NoStateChg)
		return(smOK);
	    else {
		*curstate = psm->pActArray[ActInd].TNsi;
		return(smOK);
	    }

	default:
		return(smATypeError);
	} /* switch */
    } while (1);
} /* sm_exec */
